/*	ahruman-test.js
	JavaScript test.oxp
	
	A script which responds to every event supported by Oolite 1.68 (except
	tickle, which is commented out - see bottom of file).
	This was originally written by dajt, but almost all the original script
	has been replaced.
*/
this.name			= "JavaScript-test";
this.author			= "Jens Ayton";
this.copyright		= "This work is hereby placed in the public domain.";
this.description	= "A test OXP written using JavaScript. Based on a test script by dajt.";
this.version		= "2.0";


// Called after all OXPs are launched, before the game has begun.
this.startUp = function()
{
	LogWithClass("jstest.startUp", "Script startUp called.");
}


// Called when saved game is loaded, or player respawns after dying.
this.reset = function()
{
	LogWithClass("jstest.reset", "Script reset called.");
}


function append(string, suffix)
{
	Log("Appending \"" + suffix + "\" to string \"" + string + "\".");
	
	if (string != "") string += ", ";
	string += suffix;
	return string;
}


// Called when alert status changes.
this.alertConditionChanged = function()
{
	var alertName;
	switch (player.alertCondition)
	{
		case 0:
			alertName = "docked";
			break;
		
		case 1:
			alertName = "green";
			break;
		
		case 2:
			alertName = "yellow";
			break;
		
		case 3:
			alertName = "red";
			break;
		
		default:
			alertName = "unknown value " + player.alertCondition;
	};
	
	var alertState = "";
	if (player.alertTemperature) alertState = append(alertState, "cabin temperature high");
	if (player.alertMassLocked) alertState = append(alertState, "mass locked");
	if (player.alertAltitude) alertState = append(alertState, "altitude low");
	if (player.alertHostiles) alertState = append(alertState, "hostiles present");
	if (alertState == "") alertState = "clear";
	
	LogWithClass("jstest.alert", "Player alert condition changed to " + alertName + " (" + alertState + ")");
}


// Called before launch tunnel effect.
this.willDock = function()
{
	LogWithClass("jstest.dock.begin", "Player is docking.");
}


// Called at end of docking tunnel effect.
this.didDock = function()
{
	LogWithClass("jstest.dock.complete", "Player docked at" + stationName + ", which " + (dockedAtMainStation ? "is" : "is not") + " the system's main station.");
}


// Called before launch tunnel effect.
this.willLaunch = function()
{
	LogWithClass("jstest.launch.begin", "Player is launching.");
}


// Called after launch tunnel effect.
this.didLaunch = function()
{
	LogWithClass("jstest.launch.complete", "Player \"" + player.name + "\" has launched in a " + player.shipDescription + " into galaxy " + galaxyNumber + ", planet " + planetNumber + " (\"" + system.name + "\"), govt = " + system.government + " (" + system.governmentDescription + "), economy = " + system.economy + " (" + system.economyDescription + "), tech level = " + system.techLevel);
}


// Called when player initiates witchspace countdown.
this.didBeginJumpCountDown = function(type)	// Type is one of: "standard", "galactic". Others may be added in future.
{
	LogWithClass("jstest.witchSpace.started", "Silly walk to " + type + " witchspace started.");
}


// Called if player cancels witchspace countdown.
this.didCancelJumpCountDown = function()
{
	LogWithClass("jstest.witchSpace.cancelled", "Rain dance cancelled on account of rain.");
}


// Called at end of witchspace countdown, if unsuccessful.
this.didFailToJump = function(reason)	// Reason is one of: "blocked", "too far", "insufficient fuel". Others may be added in future.
{
	switch (reason)
	{
		case "blocked":
			reason = "A station ate the chicken."
			break;
		
		case "too far":
			reason = "Our chicken isn't big enough."
			break;
		
		case "insufficient fuel":
			reason = "Bad news ain't bad enough.";
	}
	
	LogWithClass("jstest.witchSpace.failed", "Chicken-waving failed. Who ate the chicken? Reason: " + reason);
}


// Called at end of witchspace countdown, if successful, or on entring wormhole.
this.willEnterWitchSpace = function(cause)	// cause is one of: "standard jump", "galactic jump", "wormhole". Others may be added in future.
{
	LogWithClass("jstest.witchSpace.begin", "Player is entering witchspace. Cause: " + cause);
}


// Called at beginning of witchspace tunnel effect; the destination system is already set up at this time.
this.willExitWitchSpace = function()
{
	LogWithClass("jstest.witchSpace.arrive", "Player is exiting witchspace.");
}


// Called after witchspace tunnel effect.
this.didExitWitchSpace = function()
{
	LogWithClass("jstest.witchSpace.complete", "Player exited witchspace into galaxy " + galaxyNumber + ", planet " + planetNumber + " (\"" + system.name + "\"), govt = " + system.government + " (" + system.governmentDescription + "), economy = " + system.economy + " (" + system.economyDescription + "), tech level = " + system.techLevel);
}


// Called when auto-docking sequence begins (but not for insta-dock).
this.didStartAutoPilot = function()
{
	LogWithClass("jstest.autoPilot.on", "Player enabled autopilot.");
}


// Called when player cancels auto-docking sequence.
this.didAbortAutoPilot = function()
{
	LogWithClass("jstest.autoPilot.cancelled", "Player cancelled autopilot.");
}


// Station says player can't dock on account of being naughty.
this.didRecieveDockingRefusal = function()
{
	LogWithClass("jstest.autoPilot.refused", "Station refused autopilot docking.");
}


// Escape pod launched.
this.didLaunchEscapePod = function()
{
	LogWithClass("jstest.escapePod", "Player ejected... the sissy.");
}


// Player died.
this.didBecomeDead = function()
{
	LogWithClass("jstest.died", "Player has suffered an existence failure.");
}


// Called periodically, more or less.
/*this.tickle = function(status)
{
	LogWithClass("jstest.idle", "Ping! Status is: " + status);
}*/


LogWithClass("jstest.loaded", "Script loaded.");
